(function () {
  function sendClick(el) {
    var href = (el.getAttribute("href") || "").trim();

    // Sécurité côté front: on n'envoie que si tel:
    if (!href.toLowerCase().startsWith("tel:")) return;

    // sendBeacon (fiable même si redirection immédiate)
    if (navigator.sendBeacon) {
      var body = new URLSearchParams([
        ["action", PCC.action],
        ["nonce", PCC.nonce],
        ["href", href],
        ["cls", PCC.className],
      ]);
      navigator.sendBeacon(PCC.ajaxUrl, body);
      return;
    }

    // fallback fetch
    var data = new FormData();
    data.append("action", PCC.action);
    data.append("nonce", PCC.nonce);
    data.append("href", href);
    data.append("cls", PCC.className);

    fetch(PCC.ajaxUrl, {
      method: "POST",
      credentials: "same-origin",
      body: data,
    }).catch(function () {});
  }

  document.addEventListener("click", function (e) {
    var el = e.target.closest && e.target.closest("a." + PCC.className);
    if (!el) return;
    sendClick(el);
  });
})();
